#include "test.moc"
#include <kmessagebox.h>
#include <qtextview.h>

Test::Test() : KMainWindow()
{

	file = new QPopupMenu();
	file->insertItem("&About", this, SLOT(slotAbout()));
	file->insertItem("&Refresh modules", this, SLOT(slotRefresh()));
	file->insertSeparator();
	file->insertItem("&Exit", this, SLOT(slotExit()));

	menu = menuBar();
	menu->insertItem("&File", file);

	bar = statusBar();

	split = new QSplitter(this);
	split->setOrientation(Vertical);
	log = new QTextView("log", "", split);
	anotherlog = new QTextView("anotherlog", "", split);

	modulelist = new ModuleList(split);

	setCentralWidget(split);
}

void Test::closeEvent(QCloseEvent *e)
{
	KMainWindow::closeEvent(e);
}

void Test::slotAbout()
{

	KMessageBox::messageBox(0, 5,
	    "TrustedBSD MAC Module Manager\n"
	    "\n"
	    "Robert Watson\n"
	    "Network Associates Laboratories\n"
	    "Network Associates, Inc.");
}

void Test::slotRefresh()
{

	modulelist->refresh();
	bar->message("Module information refreshed\n");
}

void Test::slotExit()
{
	close();
}
