/*-
 * Copyright (c) 2005 Robert N. M. Watson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * Packet description data structure.
 */
struct packet {
	char	*p_data;		/* Pointer to buffer. */
	int	 p_len;			/* Length of data in buffer. */
	char	*p_ptr;			/* Iterator pointing into buffer. */

	struct pcap_pkthdr	p_pkthdr;	/* Optional pcap data. */
	TAILQ_ENTRY(packet)	p_list;	/* Packet list. */
};

/*
 * Public packet APIs.
 */
struct packet	*packet_new(int len, const void *data);
struct packet	*packet_new_pkthdr(int len, const void *data,
		    const struct pcap_pkthdr *pkthdr);
void		 packet_free(struct packet *p);
int		 packet_get_data(struct packet *p, int len, void *data);
int		 packet_get_int8(struct packet *p, int8_t *int8);
int		 packet_get_uint8(struct packet *p, u_int8_t *uint8);
int		 packet_get_uint16(struct packet *p, u_int16_t *uint16);
int		 packet_get_uint32(struct packet *p, u_int32_t *uint32);
int		 packet_get_uint64(struct packet *p, u_int64_t *uint64);
struct packet	*packet_get_subpacket(struct packet *p, int len);
int		 packet_skip_data(struct packet *p, int len);
