/*-
 * Copyright (c) 2006 Robert N. M. Watson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * Description of a flow.
 */
struct flow {
	void			*flow_data;
	time_t			flow_timestamp;
	TAILQ_HEAD(, packet)	flow_packets;
	TAILQ_ENTRY(flow)	flow_list;
};

/*
 * Prototypes for consumer flow class methods.
 */
typedef int	(*flow_alloc_t)(struct flow *flow, void *args);
typedef void	(*flow_free_t)(struct flow *flow);
typedef int	(*flow_matcher_t)(struct flow *flow, struct packet *p,
		    void *args);
typedef void	(*flow_update_t)(struct flow *flow, struct packet *p,
		    void *args);
typedef void	(*flow_name_t)(struct flow *flow, char *path);
typedef int	(*flow_expire_t)(struct flow *flow, time_t now);
typedef void	(*flow_print_t)(struct flow *flow);

struct flow_class {
	/* Fields defined by consumer. */
	flow_alloc_t	 fc_flow_alloc;
	flow_free_t	 fc_flow_free;
	flow_matcher_t	 fc_flow_matcher;
	flow_update_t	 fc_flow_update;
	flow_name_t	 fc_flow_name;
	flow_expire_t	 fc_flow_expire;
	flow_print_t	 fc_flow_print;

	/* Fields owned by the implementation. */
	void		*fc_data;
};

/*
 * Public APIs.
 */
int	flow_init(struct flow_class *fc);
void	flow_destroy(struct flow_class *fc);
void	flow_new_packet(struct flow_class *fc, struct packet *p, void *args);
void	flow_summary(struct flow_class *fc);
void	flow_dump(struct flow_class *fc, pcap_t *pcap, int flags);

/*
 * Flag arguments to flow_dump().
 */
#define	FLOW_DUMP_NOW	0x00000001	/* Dump immediately, no expire. */
#define	FLOW_DUMP_PRINT	0x00000002	/* Printf for each file created. */
