
/*-
 * Copyright (c) 2001 Robert N. M. Watson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: $
 */
#include <sys/param.h>
#include <sys/conf.h>
#include <sys/libkern.h>
#include <sys/uio.h>

#include "freebsd_dev.h"

static char *bikeshed_colors[] = {
	"red\n",
	"orange\n",
	"yellow\n",
	"green\n",
	"blue\n",
	"indigo\n",
	"violet\n",
	"chartreuse\n",
	"magenta\n",		/* TDF */
	"turquoise\n",		/* Holocaine */
	"cyan\n",		/* TDF */
	"mauve\n",		/* winter */
	"puce\n",		/* winter */
	"beige\n",		/* Holocaine */
	"navajo white\n",	/* softweyr */
	"forest green\n",	/* danp */
	"antique white\n",	/* softweyr */
	"turd brown\n",		/* softweyr */
	"split pea soup\n",	/* softweyr */
	"puke yellow\n",	/* DevRandom */
	"eggshell\n",		/* softweyr */
	"azure\n",		/* danp */
	"black\n",		/* quiet1 */
	"bronze\n",		/* winter */
};

static const int bikeshed_colors_count = sizeof(bikeshed_colors) /
    sizeof(char *);

static d_open_t		bikeshed_open;
static d_close_t	bikeshed_close;
static d_read_t		bikeshed_read;

struct cdevsw bikeshed_cdevsw = {
	/* open */	bikeshed_open,
	/* close */	bikeshed_close,
	/* read */	bikeshed_read,
	/* write */	(d_write_t *)nullop,
	/* ioctl */	noioctl,
	/* poll */	nopoll,
	/* mmap */	nommap,
	/* strategy */	nostrategy,
	/* name */	"bikeshed",
	/* maj */	CDEV_MAJOR,
	/* dump */	nodump,
	/* psize */	nopsize,
	/* flags */	0,
	/* bmaj */	0
};

static int	bikeshed_is_open = 0;
static int	bikeshed_color = 0;
static off_t	bikeshed_offset = 0;
static int	bikeshed_left = 0;

static int
bikeshed_open(dev_t dev, int flags, int mode, struct proc *p)
{

	if (bikeshed_is_open)
		return (EBUSY);
	bikeshed_is_open = 1;
	bikeshed_color = arc4random() % bikeshed_colors_count;
	bikeshed_offset = 0;
	bikeshed_left = strlen(bikeshed_colors[bikeshed_color]);

	return (0);
}

static int
bikeshed_close(dev_t dev, int flag, int mode, struct proc *p)
{

	bikeshed_is_open = 0;
	return (0);
}

static int
bikeshed_read(dev_t dev, struct uio *uio, int flag)
{
	int length, error;

	length = min(bikeshed_left, uio->uio_resid);
	error = uiomove(bikeshed_colors[bikeshed_color] + bikeshed_offset,
	    length, uio);
	if (error)
		return (error);
	bikeshed_left -= length;
	bikeshed_offset += length;
	return (0);
}
