/*-
 * Copyright (c) 2003 Networks Associates Technology, Inc.
 * All rights reserved.
 *
 * This software was developed for the FreeBSD Project by and Network
 * Associates Laboratories, the Security Research Division of Network
 * Associates, Inc. under DARPA/SPAWAR contract N66001-01-C-8035 ("CBOSS"),
 * as part of the DARPA CHATS research program.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD$
 */
#include <sys/types.h>
#include <sys/fcntl.h>
#include <sys/ioctl.h>

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "diskscan.h"

static int
disk_test_read_fn(int fd, char *name, int sectorsize, off_t sectorcount,
    int argc, char *argv[])
{
	off_t count, errors, res;
	char *buffer, eol;

	if (argc != 0) {
		fprintf(stderr, "Test argument error\n");
		return (-1);
	}

	if (jflag)
		eol = '\n';
	else
		eol = '\r';

	buffer = malloc(sectorsize);
	if (buffer == NULL) {
		perror("malloc");
		return (-1);
	}
	errors = 0;
	for (count = 0; count < sectorcount; count++) {
		res = read(fd, buffer, sectorsize);
		if (res == -1) {
			printf("%s sector %jd: %s\n", name, count,
			    strerror(errno));
			errors++;
		} else if (res != sectorsize) {
			printf("%s sector %jd: short read (%jd)\n", name,
			    count, res);
			errors++;
		} else if (vflag)
			printf("%s sector %jd: OK%c", name, count, eol);
	}
	free(buffer);
	printf("%s: %jd error(s)                            \n", name,
	    errors);

	return (0);
}

const struct disk_test disk_test_read = {
	"disk_test_read",
	disk_test_read_fn,
	O_RDONLY
};
