#ifndef XENVAR_H_
#define XENVAR_H_
#define XBOOTUP 0x1
#define XPMAP   0x2
extern int xendebug_flags;
#ifndef NOXENDEBUG
#define XENPRINTF printk
#else
#define XENPRINTF printf
#endif 
extern unsigned long *xen_phys_machine;
#define TRACE_ENTER XENPRINTF("(file=%s, line=%d) entered %s\n", __FILE__, __LINE__, __FUNCTION__)
#define TRACE_EXIT XENPRINTF("(file=%s, line=%d) exiting %s\n", __FILE__, __LINE__, __FUNCTION__)
#define TRACE_DEBUG(argflags, _f, _a...) \
if (xendebug_flags & argflags) XENPRINTF("(file=%s, line=%d) " _f "\n", __FILE__, __LINE__, ## _a);

extern unsigned long *xen_machine_phys;
/* Xen starts physical pages after the 4MB ISA hole -
 * FreeBSD doesn't
 */


#define ADD_ISA_HOLE

#ifdef ADD_ISA_HOLE
#define ISA_INDEX_OFFSET 1024 
#define ISA_PDR_OFFSET 1
#else
#define ISA_INDEX_OFFSET 0
#define ISA_PDR_OFFSET 0
#endif


#define PFNTOMFN(i) (((unsigned long *)xen_phys_machine)[(i)])
#define MFNTOPFN(i) (xen_machine_phys[i])

#define VTOP(x) ((unsigned long)(x) - KERNBASE)
#define PTOV(x) ((unsigned long)(x) + KERNBASE)

#define VTOPFN(x) (VTOP(x) >> PAGE_SHIFT)
#define PFNTOV(x) PTOV((unsigned long)(x)  << PAGE_SHIFT)

#define VTOMFN(va) (vtomach(va) >> PAGE_SHIFT)
#define PFN_UP(x)    (((x) + PAGE_SIZE-1) >> PAGE_SHIFT)

#define phystomach(pa) (PFNTOMFN((pa) >> PAGE_SHIFT) << PAGE_SHIFT)
#define machtophys(ma) (MFNTOPFN((ma) >> PAGE_SHIFT) << PAGE_SHIFT)


void xpq_init(void);

#define BITS_PER_LONG 32
#define NR_CPUS      MAX_VIRT_CPUS

#define BITS_TO_LONGS(bits) \
	(((bits)+BITS_PER_LONG-1)/BITS_PER_LONG)
#define DECLARE_BITMAP(name,bits) \
	unsigned long name[BITS_TO_LONGS(bits)]
typedef struct { DECLARE_BITMAP(bits, NR_CPUS); } xen_cpumask_t;

int  xen_create_contiguous_region(vm_page_t pages, int npages);

void  xen_destroy_contiguous_region(void * addr, int npages);


#endif
