/******************************************************************************
 * hypervisor.h
  * 
 * Linux-specific hypervisor handling.
 * 
 * Copyright (c) 2002, K A Fraser
 */

#ifndef __HYPERVISOR_H__
#define __HYPERVISOR_H__


#include <machine/hypervisor-ifs.h>
#include <machine/frame.h>

#if defined(CONFIG_X86_64)
#define MULTI_UVMFLAGS_INDEX 2
#define MULTI_UVMDOMID_INDEX 3
#else
#define MULTI_UVMFLAGS_INDEX 3
#define MULTI_UVMDOMID_INDEX 4
#endif


extern start_info_t *xen_start_info;
extern shared_info_t *HYPERVISOR_shared_info;

extern uint64_t get_system_time(int ticks);

static inline int 
HYPERVISOR_console_write(char *str, int count)
{
    return HYPERVISOR_console_io(CONSOLEIO_write, count, str); 
}

static inline void HYPERVISOR_crash(void) __dead2;

static inline int
HYPERVISOR_shutdown(unsigned int reason)
{
	struct sched_shutdown sched_shutdown = {
		.reason = reason
	};

	return HYPERVISOR_sched_op(SCHEDOP_shutdown, &sched_shutdown);
}

static inline void
HYPERVISOR_crash(void) 
{
        HYPERVISOR_shutdown(SHUTDOWN_crash); 
	/* NEVER REACHED */
        for (;;) ; /* eliminate noreturn error */ 
}

/* Transfer control to hypervisor until an event is detected on one */
/* of the specified ports or the specified number of ticks elapse */
static inline int
HYPERVISOR_poll(
	evtchn_port_t *ports, unsigned int nr_ports, int ticks)
{
	struct sched_poll sched_poll = {
		.ports = ports,
		.nr_ports = nr_ports,
		.timeout = get_system_time(ticks)
	};

	return HYPERVISOR_sched_op(SCHEDOP_poll, &sched_poll);
}

#endif /* __HYPERVISOR_H__ */
