/******************************************************************************
 * hypervisor.h
  * 
 * Linux-specific hypervisor handling.
 * 
 * Copyright (c) 2002, K A Fraser
 */

#ifndef __HYPERVISOR_H__
#define __HYPERVISOR_H__


#include <machine/hypervisor-ifs.h>
#include <machine/frame.h>

#if defined(CONFIG_X86_64)
#define MULTI_UVMFLAGS_INDEX 2
#define MULTI_UVMDOMID_INDEX 3
#else
#define MULTI_UVMFLAGS_INDEX 3
#define MULTI_UVMDOMID_INDEX 4
#endif


extern start_info_t *xen_start_info;
extern shared_info_t *HYPERVISOR_shared_info;

static inline int 
HYPERVISOR_console_write(char *str, int count)
{
    return HYPERVISOR_console_io(CONSOLEIO_write, count, str); 
}

static inline void HYPERVISOR_crash(void) __dead2;

static inline void
HYPERVISOR_crash(void) 
{
        _hypercall2(void, sched_op, SCHEDOP_shutdown, SHUTDOWN_crash); 
	/* NEVER REACHED */
        for (;;) ; /* eliminate noreturn error */ 
}


#endif /* __HYPERVISOR_H__ */
