/*	$NetBSD: ieee80211_compat.h,v 1.4 2003/10/15 08:13:28 itojun Exp $	*/
/*-
 * Copyright (c) 2003, 2004 David Young
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef _NET80211_IEEE80211_COMPAT_H_
#define _NET80211_IEEE80211_COMPAT_H_

#ifdef __NetBSD__
#include "bpfilter.h"

#undef KASSERT
#define KASSERT(cond, complaint) if (!(cond)) panic complaint

#define	IEEE80211_NODE_LOCK_INIT(_ic, _name)
#define IEEE80211_NODE_LOCK(_ic)	do { _s = splnet(); } while (0)
#define IEEE80211_NODE_UNLOCK(_ic)	do { splx(_s); } while (0)
#define	IEEE80211_NODE_LOCK_DESTROY(_ic)

void if_printf(struct ifnet *, const char *, ...)
    __attribute__((__format__(__printf__,2,3)));

#define ieee80211_node_incref(ni)			\
	do {						\
		int _s = splnet();			\
		(ni)->ni_refcnt++;			\
		splx(_s);				\
	} while (0)

static __inline int
ieee80211_node_decref(struct ieee80211_node *ni)
{
	int refcnt, s;
	s = splnet();
	refcnt = --ni->ni_refcnt;
	splx(s);
	return refcnt;
}

#define	ifmedia_removeall(_media) \
        ifmedia_delete_instance((_media), IFM_INST_ANY)
#endif /* __NetBSD__ */

#ifdef __FreeBSD__
#define	NBPFILTER	1		/* always enabled */

/*
 * Locking definitions.
 */
#define	IEEE80211_NODE_LOCK_INIT(_ic, _name) \
	mtx_init(&(_ic)->ic_nodelock, _name, "802.11 node table", MTX_DEF)
#define	IEEE80211_NODE_LOCK_DESTROY(_ic)	mtx_destroy(&(_ic)->ic_nodelock)
#define	IEEE80211_NODE_LOCK(_ic)		mtx_lock(&(_ic)->ic_nodelock)
#define	IEEE80211_NODE_UNLOCK(_ic)		mtx_unlock(&(_ic)->ic_nodelock)
#define	IEEE80211_NODE_LOCK_ASSERT(_ic) \
	mtx_assert(&(_ic)->ic_nodelock, MA_OWNED)

#define	M_LINK0		M_PROTO1
#define	ALTQ_DECL(_x)

/*
 * Node reference counting definitions.
 */
#define ieee80211_node_incref(ni) atomic_add_int(&(ni)->ni_refcnt, 1)

static __inline int
ieee80211_node_decref(struct ieee80211_node *ni)
{
	int orefcnt;
	do {
		orefcnt = ni->ni_refcnt;
	} while (atomic_cmpset_int(&ni->ni_refcnt, orefcnt, orefcnt - 1) == 0);
	return orefcnt - 1;
}
#endif /* __FreeBSD__ */

#endif /* _NET80211_IEEE80211_COMPAT_H_ */
