
#include "stdafx.h"
#include <mmsystem.h>
#include <math.h>
#include "dsound.h"
#include "mpegsound.h"
#include "M1.h"
#include "M1Dlg.h"
#include "OptionsDlg.h"
#include "PlaylistDlg.h"
#include "ConfigDlg.h"


extern HWND myhwnd;
extern CM1Dlg * md;
extern HANDLE threadHandle;
extern BOOL useSurroundSound;
extern BOOL useVolumeBars;
extern COptionsDlg * od;
extern CPlaylistDlg * pd;
extern CConfigDlg * cd;


void MyDsound::Die()
{
	Stop();
}

void MyDsound::init(float bSize)
{
    HRESULT     dsRetVal;
	DSBUFFERDESC dsbd;
	WAVEFORMATEX wf;
	int			timerid;

	bSize = cd->m_bufferSize.GetPos()*(4608.0/176400.0);

	bufferSize = (long)(bSize*176400);
	playWrap	= 0;
	writeWrap	= 0;
	playPtr	    = 0;
	writePtr	= 0;
	SwritePtr	= 0;

	dsRetVal = DirectSoundCreate(NULL, &lpDS, NULL );

	if( dsRetVal != DS_OK )
	{
		MessageBox(myhwnd,"Could not create IDirectSound","Doh!",MB_ICONERROR);
	}

    dsRetVal = lpDS->SetCooperativeLevel(myhwnd,DSSCL_EXCLUSIVE);
	//needs to be priority rather than normal so that I can use the SetFormat
	//call
    


	if( dsRetVal != DS_OK )
    {
		MessageBox(myhwnd,"Could not set priority level","Doh!",MB_ICONERROR);
    }

	memset( &dsbd, 0, sizeof( DSBUFFERDESC ));
    dsbd.dwSize = sizeof( DSBUFFERDESC );
    dsbd.dwFlags = DSBCAPS_PRIMARYBUFFER;
	dsbd.dwBufferBytes = 0;

    dsbd.lpwfxFormat = NULL;
    dsRetVal = lpDS->CreateSoundBuffer(&dsbd,&lpDSBPrimaryBuffer,NULL );
	switch (dsRetVal)
	{
		case DSERR_ALLOCATED: MessageBox(myhwnd,"Primary Buffer - Already Allocated","Doh!",MB_ICONERROR); break;
		case DSERR_BADFORMAT: MessageBox(myhwnd,"Primary Buffer - Bad Format","Doh!",MB_ICONERROR); break;
		case DSERR_INVALIDPARAM: MessageBox(myhwnd,"Primary Buffer - Invalid Parameters","Doh!",MB_ICONERROR); break;
		case DSERR_NOAGGREGATION: MessageBox(myhwnd,"Primary Buffer - No Aggregation","Doh!",MB_ICONERROR); break;
		case DSERR_OUTOFMEMORY: MessageBox(myhwnd,"Primary Buffer - Out of Memory","Doh!",MB_ICONERROR); break;
		case DSERR_UNINITIALIZED: MessageBox(myhwnd,"Primary Buffer - Uninitialized Primary Buffer","Doh!",MB_ICONERROR); break;
		case DSERR_UNSUPPORTED: MessageBox(myhwnd,"Primary Buffer - Unsupported","Doh!",MB_ICONERROR); break;
	}
	memset( &wf, 0, sizeof( WAVEFORMATEX ));
	wf.wFormatTag      = WAVE_FORMAT_PCM;
	wf.nChannels       = 2;
	wf.nSamplesPerSec  = 44100;
	wf.nAvgBytesPerSec = 44100*2*2;
	wf.nBlockAlign     = 4;
	wf.wBitsPerSample  = 16;
	wf.cbSize          = 0;
	
	dsRetVal = lpDSBPrimaryBuffer->SetFormat(&wf); //set format of primary sound buffer
	switch (dsRetVal)
	{
		case DSERR_ALLOCATED: MessageBox(myhwnd,"Already allocated","Doh!",MB_ICONERROR); break;
		case DSERR_BADFORMAT: MessageBox(myhwnd,"Bad Format","Doh!",MB_ICONERROR); break;
		case DSERR_INVALIDPARAM: MessageBox(myhwnd,"Invalid Parameter","Doh!",MB_ICONERROR); break;
		case DSERR_INVALIDCALL: MessageBox(myhwnd,"Invalid Call","Doh!",MB_ICONERROR); break;
		case DSERR_OUTOFMEMORY: MessageBox(myhwnd,"Out of Memory","Doh!",MB_ICONERROR); break;
		case DSERR_PRIOLEVELNEEDED: MessageBox(myhwnd,"Priority Level Needed","Doh!",MB_ICONERROR); break;
		case DSERR_UNSUPPORTED: MessageBox(myhwnd,"Unsupported","Doh!",MB_ICONERROR); break;
	}

//setup the secondary buffer
	memset( &dsbd, 0, sizeof( DSBUFFERDESC ));
    dsbd.dwSize = sizeof( DSBUFFERDESC );
    dsbd.dwFlags = DSBCAPS_STICKYFOCUS | DSBCAPS_CTRLVOLUME;
	dsbd.dwBufferBytes = bufferSize;
 
	memset( &wf, 0, sizeof( WAVEFORMATEX ));
	wf.wFormatTag      = WAVE_FORMAT_PCM;
	wf.nChannels       = 2;
	wf.nSamplesPerSec  = 44100;
	wf.nAvgBytesPerSec = 44100*2*2;
	wf.nBlockAlign     = 4;
	wf.wBitsPerSample  = 16;
	wf.cbSize          = 0;

    dsbd.lpwfxFormat = &wf;
    dsRetVal = lpDS->CreateSoundBuffer(&dsbd,&lpDSBStreamBuffer,NULL);

	switch (dsRetVal)
	{
		case DSERR_ALLOCATED: MessageBox(myhwnd,"Secondary Buffer - Already Allocated","Doh!",MB_ICONERROR); break;
		case DSERR_BADFORMAT: MessageBox(myhwnd,"Secondary Buffer - Bad Format","Doh!",MB_ICONERROR); break;
		case DSERR_INVALIDPARAM: MessageBox(myhwnd,"Secondary Buffer - Invalid Parameters","Doh!",MB_ICONERROR); break;
		case DSERR_NOAGGREGATION: MessageBox(myhwnd,"Secondary Buffer - No Aggregation","Doh!",MB_ICONERROR); break;
		case DSERR_OUTOFMEMORY: MessageBox(myhwnd,"Secondary Buffer - Out of Memory","Doh!",MB_ICONERROR); break;
		case DSERR_UNINITIALIZED: MessageBox(myhwnd,"Secondary Buffer - Uninitialized Primary Buffer","Doh!",MB_ICONERROR); break;
		case DSERR_UNSUPPORTED: MessageBox(myhwnd,"Secondary Buffer - Unsupported","Doh!",MB_ICONERROR); break;
	}

    lpDSBStreamBuffer->SetCurrentPosition(0);

	if(useSurroundSound)
	{
		//setup the surround buffer
		memset( &dsbd, 0, sizeof( DSBUFFERDESC ));
		dsbd.dwSize = sizeof( DSBUFFERDESC );
		dsbd.dwFlags = DSBCAPS_STICKYFOCUS | DSBCAPS_CTRLVOLUME;
		dsbd.dwBufferBytes = bufferSize;
	 
		memset( &wf, 0, sizeof( WAVEFORMATEX ));
		wf.wFormatTag      = WAVE_FORMAT_PCM;
		wf.nChannels       = 1;
		wf.nSamplesPerSec  = 44100;
		wf.nAvgBytesPerSec = 44100*2;
		wf.nBlockAlign     = 2;
		wf.wBitsPerSample  = 16;
		wf.cbSize          = 0;
	
	    dsbd.lpwfxFormat = &wf;
	    dsRetVal = lpDS->CreateSoundBuffer(&dsbd,&lpDSBSurroundBuffer,NULL);

		switch (dsRetVal)
		{
			case DSERR_ALLOCATED: MessageBox(myhwnd,"Surround Buffer - Already Allocated","Doh!",MB_ICONERROR); break;
			case DSERR_BADFORMAT: MessageBox(myhwnd,"Surround Buffer - Bad Format","Doh!",MB_ICONERROR); break;
			case DSERR_INVALIDPARAM: MessageBox(myhwnd,"Surround Buffer - Invalid Parameters","Doh!",MB_ICONERROR); break;
			case DSERR_NOAGGREGATION: MessageBox(myhwnd,"Surround Buffer - No Aggregation","Doh!",MB_ICONERROR); break;
			case DSERR_OUTOFMEMORY: MessageBox(myhwnd,"Surround Buffer - Out of Memory","Doh!",MB_ICONERROR); break;
			case DSERR_UNINITIALIZED: MessageBox(myhwnd,"Surround Buffer - Uninitialized Primary Buffer","Doh!",MB_ICONERROR); break;
			case DSERR_UNSUPPORTED: MessageBox(myhwnd,"Surround Buffer - Unsupported","Doh!",MB_ICONERROR); break;
		}
	
	    lpDSBSurroundBuffer->SetCurrentPosition(0);
	}

	playing = false;

//	progress = &od->m_buffer;
//	progress->SetRange(0,100);
//	progress->SetPos(0);

//	lvolume = &od->m_lvolume;
//	rvolume = &od->m_rvolume;
//	lvolume->SetPos(0);
//	rvolume->SetPos(0);

	volume = &md->m_masterVolume;
	volume->SetRange(1,100);
	volume->SetPos(1);
	priority = 0;
	exit = false;
	paused = false;

	myBuffer = NULL;
	if((useSurroundSound)||(useVolumeBars))
	{
		//get a big buffer
		myBuffer = new short[bufferSize];
	}

}

void MyDsound::writeToDsound(void * buffer, int size)
{

	DWORD tempP;
	DWORD tempW;
	dwLen = size;
	short * surround;
	short * buf;

	if(!playing)
	{
		//wait until the buffer is 20% full
		if(PercentValidBufferLeft()>cd->m_preBuffering.GetPos())
		{
			lpDSBStreamBuffer->Play(0, 0, DSBPLAY_LOOPING );
			if(useSurroundSound) lpDSBSurroundBuffer->Play(0, 0, DSBPLAY_LOOPING );
			playing = true;
		}
		
	}else
	{
		lpDSBStreamBuffer->GetCurrentPosition(&tempP,&tempW);
		if(tempP < playPtr) playWrap++;
		playPtr = tempP;

		if((ValidBufferLeft()<0)&&(writeWrap>0)) writeWrap--;
		while(ValidBufferLeft()>(bufferSize-size))
		{
		//we are getting ahead of playing, so sleep for a while and try again
	//		Sleep(1000*bufferSize/176400/2);
			Sleep(10);
			lpDSBStreamBuffer->GetCurrentPosition(&tempP,&tempW);
			if(tempP < playPtr) playWrap++;
			playPtr = tempP;
//			progress->SetPos(PercentValidBufferLeft());
		}

	}
	
	//get surround channel
	if(useSurroundSound)
	{
		buf = (short *)buffer;
		surround = new short[size/2];

		for(int x=0;x<(size/4);x++)
		{
			surround[x] = buf[2*x+1]/2 - buf[2*x]/2;
		}
		dsRetVal = lpDSBSurroundBuffer->Lock(SwritePtr, size/2,&lpWrite, &dwLen,&lpWrite2, &dwLen2, 0 );
			
		memcpy(lpWrite,surround,dwLen);
		if(lpWrite2!=NULL){
			memcpy(lpWrite2,(LPBYTE)surround+dwLen,dwLen2);
		}else dwLen2 = 0;


		dsRetVal = lpDSBSurroundBuffer->Unlock((LPVOID)lpWrite, dwLen, (LPVOID)lpWrite2, dwLen2 );
		SwritePtr = (SwritePtr + size/2) % bufferSize;
	
		delete surround;
	}
	
	
	dsRetVal = lpDSBStreamBuffer->Lock(writePtr, size,&lpWrite, &dwLen,&lpWrite2, &dwLen2, 0 );
		
	memcpy(lpWrite,buffer,dwLen);
	if(lpWrite2!=NULL){
		memcpy(lpWrite2,(LPBYTE)buffer+dwLen,dwLen2);
	}else dwLen2 = 0;

	if((useSurroundSound)||(useVolumeBars))
	{
		//update my buffer
		buf = myBuffer;
		tempW = writePtr;
		buf = buf + tempW;
		memcpy(buf,buffer,dwLen);
		buf = myBuffer;
		tempW = tempW + dwLen;
		tempW %=bufferSize;
		buf = buf + tempW;
		memcpy(buf,(LPBYTE)buffer+dwLen,dwLen2);
	}

	dsRetVal = lpDSBStreamBuffer->Unlock((LPVOID)lpWrite, dwLen, (LPVOID)lpWrite2, dwLen2 );

	tempW = writePtr;
	writePtr = (writePtr + size) % bufferSize;
	if(tempW > writePtr) writeWrap++;
	modCounter++;
	modCounter = modCounter%10;
	if(!modCounter)
	{
		double vol;
//		progress->SetPos(PercentValidBufferLeft()); //only set progress bar ~4 times a sec
		SetPriority(PercentValidBufferLeft()); //only set priority ~4 times a sec
		vol = (101 - volume->GetPos())/100.0;
		vol = 1000*log(1/vol);
		vol = vol/(log(2));
		lpDSBStreamBuffer->SetVolume((long)-vol);
		if(useSurroundSound) lpDSBSurroundBuffer->SetVolume((long)-vol);
	}

}

long MyDsound::ValidBufferLeft()
{
	DWORD tempP;
	DWORD tempW;
	lpDSBStreamBuffer->GetCurrentPosition(&tempP,&tempW);
	if(tempP < playPtr) playWrap++;
	playPtr = tempP;
	
	return (writePtr + writeWrap*bufferSize) - (playPtr+playWrap*bufferSize);

}

long MyDsound::PercentValidBufferLeft()
{
	DWORD tempP;
	DWORD tempW;
	lpDSBStreamBuffer->GetCurrentPosition(&tempP,&tempW);
	if(tempP < playPtr) playWrap++;
	playPtr = tempP;
	
	return 100*((writePtr + writeWrap*bufferSize) - (playPtr+playWrap*bufferSize))/bufferSize;

}

void MyDsound::Stop()
{
	writePtr = 0;
	writeWrap = 0;
	playPtr = 0;
	playWrap = 0;
//	progress->SetPos(0);
	if(playing)
	{
		lpDSBStreamBuffer->Stop();
		lpDSBPrimaryBuffer->Stop();
		if(useSurroundSound) lpDSBSurroundBuffer->Stop();
	}

}

void MyDsound::SetPriority(int percentFull)
{
	int newpriority;
	if(playing)
	{
		newpriority = priority;
		if((priority==0)&&(percentFull < 20))// if normal priority and buffer below 20, increse priority
			newpriority = 1;
		if((priority==1)&&(percentFull > 50))// if normal priority and buffer above 70, decrese priority
			newpriority = 1;
		if(newpriority != priority)
		{
			if(newpriority==0)
			{
				SetThreadPriority(threadHandle,THREAD_PRIORITY_NORMAL);
				priority = 0;
			}else
			{
				SetThreadPriority(threadHandle,THREAD_PRIORITY_HIGHEST);
				priority = 1;
			}
		}
	}
}
