// M1Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "M1.h"
#include "M1Dlg.h"
#include "OptionsDlg.h"
#include "PlaylistDlg.h"
#include "ConfigDlg.h"
#include "Scopes.h"
#include "play.cpp"
#include "resource.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

HWND myhwnd;
MyDsound * mds;
CM1Dlg * d;
COptionsDlg * od;
CPlaylistDlg * pd;
CConfigDlg * cd;
Scopes * sd;
CFont myFont;
long hertz;
long bitrate;

BOOL useVolumeBars;
BOOL useSurroundSound;
BOOL useDynamicPriority;
BOOL usePlayList;
BOOL odViewable;
BOOL sdViewable;
BOOL pdViewable;
BOOL cdViewable;
BOOL stereo;

extern HICON icoPlay;
extern HICON icoPlayOn;
extern HICON icoFf;
extern HICON icoRw;
extern HICON icoSkipf;
extern HICON icoSkipb;
extern HICON icoStop;
extern HICON icoOption;

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CM1Dlg dialog

CM1Dlg::CM1Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CM1Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CM1Dlg)
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CM1Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CM1Dlg)
	DDX_Control(pDX, IDC_RVOLUME, m_rVolume);
	DDX_Control(pDX, IDC_LVOLUME, m_lVolume);
	DDX_Control(pDX, IDC_VOLUME, m_masterVolume);
	DDX_Control(pDX, IDC_FREQUENCY, m_frequency);
	DDX_Control(pDX, IDC_STEREO, m_stereo);
	DDX_Control(pDX, IDC_BITRATE, m_bitrate);
	DDX_Control(pDX, IDC_PLAYPOINT, m_playPoint);
	DDX_Control(pDX, IDC_SONGNAME, m_songName);
	DDX_Control(pDX, IDOK, m_option);
	DDX_Control(pDX, IDC_SKIPB, m_skipb);
	DDX_Control(pDX, IDC_STOP, m_stop);
	DDX_Control(pDX, IDC_SKIPF, m_skipf);
	DDX_Control(pDX, IDC_REWIND, m_rw);
	DDX_Control(pDX, IDC_FASTF, m_ff);
	DDX_Control(pDX, IDC_PLAY, m_play);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CM1Dlg, CDialog)
	ON_WM_CONTEXTMENU()
	//{{AFX_MSG_MAP(CM1Dlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_PLAY, OnPlay)
	ON_BN_CLICKED(IDC_STOP, OnStop)
	ON_WM_DROPFILES()
	ON_BN_CLICKED(IDC_FASTF, OnFastf)
	ON_BN_CLICKED(IDC_REWIND, OnRewind)
	ON_BN_CLICKED(IDC_SKIPB, OnSkipb)
	ON_BN_CLICKED(IDC_SKIPF, OnSkipf)
	ON_BN_CLICKED(IDC_SCOPES, OnScopes)
	ON_BN_CLICKED(IDC_CONFIGBUTTON, OnConfigbutton)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CM1Dlg message handlers

BOOL CM1Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	CString strAboutMenu;
	strAboutMenu.LoadString(IDS_ABOUTBOX);
	if (!strAboutMenu.IsEmpty())
	{
		pSysMenu->AppendMenu(MF_SEPARATOR);
		pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
	}

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	//create some other dialogs
	od = new COptionsDlg();
	pd = new CPlaylistDlg();
	sd = new Scopes();
	cd = new CConfigDlg();
	od->Create(IDD_BELLSANDWHISTLES,this);
	pd->Create(IDD_PLAYLIST,this);
	sd->Create(IDD_SCOPES,this);
	cd->Create(IDD_CONFIG,this);
	odViewable = false;
	sdViewable = false;
	pdViewable = false;
	cdViewable = false;

	myhwnd = GetSafeHwnd();
	mp3Name[0] = 0;
	mds = NULL;
	m_masterVolume.SetRange(1,100);
	m_masterVolume.SetPos(1);
	cd->m_bufferSize.SetRange(30,765);
	cd->m_bufferSize.SetPos(216);
	cd->m_preBuffering.SetRange(1,100);
	cd->m_preBuffering.SetPos(20);

	d = this;
	//set up the config dialog box
	useVolumeBars = false;
	
	DragAcceptFiles(TRUE);
	usePlayList = false;

//	if (this->m_lpCmdLine[0] != '\0')
	{
		// TODO: add command line processing here

		
	}
		
	m_play.SetIcon(icoPlay);
	m_ff.SetIcon(icoFf);
	m_rw.SetIcon(icoRw);
	m_skipf.SetIcon(icoSkipf);
	m_skipb.SetIcon(icoSkipb);
	m_stop.SetIcon(icoStop);
	m_option.SetIcon(icoOption);
	m_songName.SetWindowText("No Song Loaded"); // SetTextColor
	myFont.CreatePointFont(200,"Courier New Bold");
	m_playPoint.SetFont(&myFont);

	m_frequency.SetWindowText("");
	m_bitrate.SetWindowText("");
	m_stereo.SetWindowText("");
	m_playPoint.SetWindowText("--:--");

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CM1Dlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CM1Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}


}

HCURSOR CM1Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CM1Dlg::OnPlay() 
{
	if(!mds) //only play if mds is NULL
	{
		OnStop();
		SetFocus();
		if(mp3Name[0] != 0)
		{
			stop = false;
			useVolumeBars = od->m_useVolumeBars.GetCheck(); //cbutton
			useSurroundSound = od->m_useSurroundSound.GetCheck();
			threadHandle = CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)play,this,0,&threadID);
			SetThreadPriority(threadHandle,THREAD_PRIORITY_NORMAL);
		}
		m_play.SetIcon(icoPlayOn);
		m_play.SetWindowText("||");
	}else
	{
		if(!mds->paused)
		{
			mds->paused = true;
			mds->lpDSBPrimaryBuffer->Stop();
			mds->lpDSBStreamBuffer->Stop();
			if(useSurroundSound) mds->lpDSBSurroundBuffer->Stop();
			m_play.SetIcon(icoPlay);
			m_play.SetWindowText(">");
		}
		else
		{
			mds->paused = false;
			mds->lpDSBPrimaryBuffer->Play(0,0,DSBPLAY_LOOPING);
			mds->lpDSBStreamBuffer->Play(0,0,DSBPLAY_LOOPING);
			if(useSurroundSound) mds->lpDSBSurroundBuffer->Play(0,0,DSBPLAY_LOOPING);
			m_play.SetIcon(icoPlayOn);
			m_play.SetWindowText("||");
		}
	}
}


void CM1Dlg::OnStop() 
{
	DWORD exitStatus;
	if(mds)
	{
		stop = true;
		mds->exit = true; //signal the thread to die as soon as next chunk is written

		GetExitCodeThread(threadHandle,&exitStatus);
		while(exitStatus == STILL_ACTIVE)
		{
			GetExitCodeThread(threadHandle,&exitStatus);
			Sleep(100); //while there is still another copy, just sit around....
		}
		m_play.SetIcon(icoPlay);
		m_play.SetWindowText(">");
	}
}


/*void CM1Dlg::OnOpenfile() 
{
	CFileDialog * cfd;
//	static char BASED_CODE szFilter[] = 
//		"MP3 files (*.mp3) | *.mp3 | M3U playlists (*.m3u) | *.m3u ||";
  

	cfd = new CFileDialog(TRUE);
	
	if(cfd->DoModal()==IDOK)
	{
		strcpy(mp3Name,cfd->GetPathName().GetBuffer(0));
//		m_songName.SetWindowText(mp3Name);
	}
	
	delete cfd;
}*/



void CM1Dlg::OnDropFiles(HDROP hDropInfo) 
{
	// TODO: Add your message handler code here and/or call default
	UINT nummp3,namesize;
	char *fname;

	nummp3=DragQueryFile(hDropInfo,0xFFFFFFFF,NULL,0);
	namesize=DragQueryFile(hDropInfo,0,NULL,0);
	fname=new char[namesize+1];
	DragQueryFile(hDropInfo,0,fname,namesize+1);

	strcpy(mp3Name,fname);
	m_songName.SetWindowText(strrchr(mp3Name,'\\')+1); 

	delete fname;

	OnStop(); //kill anything that is running right now.
	SetForegroundWindow();
	if(mp3Name[0] != 0)
	{
		stop = false;
//		play(this);
		useVolumeBars = od->m_useVolumeBars.GetCheck();
		useSurroundSound = od->m_useSurroundSound.GetCheck();
		threadHandle = CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)play,this,0,&threadID);
		SetThreadPriority(threadHandle,THREAD_PRIORITY_NORMAL);
		m_play.SetIcon(icoPlayOn);
		m_play.SetWindowText("||");
	}

}

void CM1Dlg::OnFastf() 
{
	// TODO: Add your control notification handler code here
	
}

void CM1Dlg::OnRewind() 
{
	// TODO: Add your control notification handler code here	
}

void CM1Dlg::OnSkipb() 
{
	// TODO: Add your control notification handler code here
	if((mds)&&(usePlayList == true))
	{
		mds->exit = true; //signal the thread to die as soon as next chunk is written
		playlistsong--;
		playlistsong--; //do it twice because it increments automatically
	}
}

void CM1Dlg::OnSkipf() 
{
	// TODO: Add your control notification handler code here
	if((mds)&&(usePlayList == true))
	{
		mds->exit = true; //signal the thread to die as soon as next chunk is written
	}
	
}

void CM1Dlg::OnOK() //this is actually the Option button
{
	if(odViewable)
	{
		int l,r,t;
		WINDOWPLACEMENT wpl;
		GetWindowPlacement(&wpl);
		t = wpl.rcNormalPosition.top;
		l = wpl.rcNormalPosition.left;
		r = wpl.rcNormalPosition.right;

		odViewable = false;
		for(;l<r;r-=4) od->SetWindowPos(this,r,t,0,0,SWP_SHOWWINDOW|SWP_NOSIZE);
		od->ShowWindow(SW_HIDE);
	}else
	{
		int l,r,t;
		WINDOWPLACEMENT wpl;
		GetWindowPlacement(&wpl);
		t = wpl.rcNormalPosition.top;
		l = wpl.rcNormalPosition.left;
		r = wpl.rcNormalPosition.right;
		
		odViewable = true;
		od->SetWindowPos(this,l,t,0,0,SWP_SHOWWINDOW|SWP_NOSIZE);
		for(;l<r;l+=4) od->SetWindowPos(this,l,t,0,0,SWP_SHOWWINDOW|SWP_NOSIZE);
		od->SetWindowPos(this,r,t,120,47,SWP_SHOWWINDOW|SWP_NOSIZE);
	}
}



BOOL CM1Dlg::DestroyWindow() 
{
	// TODO: Add your specialized code here and/or call the base class
	delete od;
	delete pd;
	delete cd;
	delete sd;
	
	return CDialog::DestroyWindow();
}

void CM1Dlg::OnScopes() 
{
	// TODO: Add your control notification handler code here
	if(sdViewable)
	{
		int l,r,t;
		WINDOWPLACEMENT wpl;
		GetWindowPlacement(&wpl);
		t = wpl.rcNormalPosition.top;
		l = wpl.rcNormalPosition.left;
		r = wpl.rcNormalPosition.right;

		sdViewable = false;
		for(;l<r;r-=4) sd->SetWindowPos(this,r,t,0,0,SWP_SHOWWINDOW|SWP_NOSIZE);
		sd->ShowWindow(SW_HIDE);
	}else
	{
		int l,r,t;
		WINDOWPLACEMENT wpl;
		GetWindowPlacement(&wpl);
		t = wpl.rcNormalPosition.top;
		l = wpl.rcNormalPosition.left;
		r = wpl.rcNormalPosition.right;
		
		sdViewable = true;
		sd->SetWindowPos(this,l,t,0,0,SWP_SHOWWINDOW|SWP_NOSIZE);
		for(;l<r;l+=4) sd->SetWindowPos(this,l,t,0,0,SWP_SHOWWINDOW|SWP_NOSIZE);
		sd->SetWindowPos(this,r,t,120,47,SWP_SHOWWINDOW|SWP_NOSIZE);
	}	
}


void CM1Dlg::OnConfigbutton() 
{
	// TODO: Add your control notification handler code here
	if(cdViewable)
	{

		cdViewable = false;
		cd->ShowWindow(SW_HIDE);
	}else
	{
		cdViewable = true;
		cd->ShowWindow(SW_SHOW);
	}	
	
}
